//Source file: H:\middleware\src\Alkindi\BusinessServices\Util\UserData.java

package Alkindi.Services.InternalData;

/* 
$Header: PCRatDataByUser.java, 12, 4/26/01 2:36:58 PM, Schwartz, Joe$
$Log: 
 12   Alkindi Development1.11        4/26/01 2:36:58 PM   Schwartz, Joe  
      Modifed to account for movement to new packages.
 11   Alkindi Development1.10        4/26/01 1:46:06 PM   Schwartz, Joe   Moved
      to new package.
 10   Alkindi Development1.9         12/28/00 1:07:26 PM  Schwartz, Joe   Added
      Version Control header info.
 9    Alkindi Development1.8         12/27/00 1:43:15 PM  Schwartz, Joe   
 8    Alkindi Development1.7         12/26/00 6:57:14 PM  Schwartz, Joe   
 7    Alkindi Development1.6         12/19/00 5:42:15 PM  Schwartz, Joe   
 6    Alkindi Development1.5         12/19/00 2:55:31 PM  Schwartz, Joe   
 5    Alkindi Development1.4         12/19/00 2:55:15 PM  Schwartz, Joe   Added
      calcWeigth functions.
 4    Alkindi Development1.3         12/18/00 6:08:54 PM  Schwartz, Joe   
 3    Alkindi Development1.2         12/18/00 4:52:01 PM  Schwartz, Joe   
 2    Alkindi Development1.1         12/18/00 4:51:44 PM  Schwartz, Joe   
 1    Alkindi Development1.0         11/8/00 3:00:20 PM   Schwartz, Joe   
$
$NoKeywords$
 */

/**
 * Represents a row of data returned by the stored proc pkg_ALKINDI_EVALUATION.SP_SEL_USER_DATA
 */
public class PCRatDataByUser 
{
	public double b = 0;
	public double F = 0;
	public double Eave = 0;
	public double Rave = 0;
	public double R = 0;
	public double n = 0;
	public double E = 0;
	
	/**
	 * Calcuates a weight for the Product Cluster corresponding to the UserData object.
	 * @param A a tunable parameter
	 * @param B a tunable parameter
	 * @param C a tunable parameter
	 * @return double
	 * @roseuid 3A40D2680157
	 */
	public double calcWeight(final double A, final double B, final double C) 
	{
		return n*Math.exp(A*(R-Rave)+B*(E-Eave)-C*F-b);
	}
}
